/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.CmdExtendedErrorList;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspIoSimpleCmds {
    private static FspIoSimpleCmds mInst;
    private static final String ERROR_TYPE = "ERROR_TYPE";
    private static final String ERROR_DATA = "ERROR_DATA";
    public static final int TIMEOUT_MINUTE = 60000;
    private static final String SET_LPAR_PENDING_MAXIMUM_NUMBER_OF_VIRTUAL_SLOTS = "SET_LPAR_PENDING_MAXIMUM_NUMBER_OF_VIRTUAL_SLOTS";
    private static final String CLEAR_VIRTUAL_IO_SLOT_CONFIGURATION_STATE = "CLEAR_VIRTUAL_IO_SLOT_CONFIGURATION_STATE";
    private static final String GET_VIRTUAL_IO_CAPABILITIES = "GET_VIRTUAL_IO_CAPABILITIES";
    private static final String MAX_VETH_IDS = "MAX_VETH_IDS";
    private static final String GET_VIRTUAL_IO_SLOT_DRC_INDEX_AND_NAME = "GET_VIRTUAL_IO_SLOT_DRC_INDEX_AND_NAME";
    private static final String SET_IO_SLOT_OWNER_AND_POOL_ID = "SET_IO_SLOT_OWNER_AND_POOL_ID";
    private static final String VARY_ON_OFF_IO_SLOT = "VARY_ON_OFF_IO_SLOT";
    private static final String GET_LPAR_IO_POOL_CONFIGURATION = "GET_LPAR_IO_POOL_CONFIGURATION";
    private static final String IO_POOL_LIST = "IO_POOL_LIST";
    private static final String IO_POOL_ID = "IO_POOL_ID";
    private static final String LPAR_ID = "LPAR_ID";
    private static final String SET_LPAR_IO_POOL_CONFIGURATION = "SET_LPAR_IO_POOL_CONFIGURATION";
    private static final String SET_SHARED_MEMORY_CLUSTER_IO = "SET_SHARED_MEMORY_CLUSTER_IO";

    static FspIoSimpleCmds getInstance() {
        if (mInst == null) {
            mInst = new FspIoSimpleCmds();
        }
        return mInst;
    }

    private FspIoSimpleCmds() {
    }

    void setLparPendingNumberOfVirtualSlotsCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(SET_LPAR_PENDING_MAXIMUM_NUMBER_OF_VIRTUAL_SLOTS, new String[]{unsignedInt16.toString(), unsignedInt162.toString()}, 0, null, null, null, null, unsignedInt162);
    }

    void clearVirtualIoSlotConfigurationCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(CLEAR_VIRTUAL_IO_SLOT_CONFIGURATION_STATE, new String[]{unsignedInt16.toString(), unsignedInt162.toString()}, 0, null, null, null, null, unsignedInt162);
    }

    UnsignedInt16 getVirtualIoCapabilitiesCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_VIRTUAL_IO_CAPABILITIES, null);
        return (UnsignedInt16)hashtable.get(MAX_VETH_IDS);
    }

    Hashtable getVirtualIoDrcIndexAndNameCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = fSPCmdMgr.doPhypCommand(GET_VIRTUAL_IO_SLOT_DRC_INDEX_AND_NAME, new String[]{unsignedInt16.toString(), unsignedInt162.toString()}, 0, null, null, null, null, unsignedInt162);
        return hashtable;
    }

    void setIoSlotOwnerAndPoolIdCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt32 unsignedInt32, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(SET_IO_SLOT_OWNER_AND_POOL_ID, new String[]{unsignedInt32.toString(), unsignedInt16.toString(), unsignedInt162.toString(), unsignedInt8.toString()}, unsignedInt32);
    }

    void varyOnOffIoCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt32 unsignedInt32, UnsignedInt8 unsignedInt8, UnsignedInt8 unsignedInt82) throws PIHscServerException, PIHscCmdMgrException {
        int n = unsignedInt162.intValue() * 60000;
        String[] stringArray = new String[]{unsignedInt16.toString(), unsignedInt162.toString(), unsignedInt32.toString(), unsignedInt8.toString(), unsignedInt82.toString()};
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(VARY_ON_OFF_IO_SLOT, stringArray, n, null, unsignedInt32, null, null, null);
        int n2 = (Integer)hashtable.get(ERROR_TYPE);
        if (n2 == 33006) {
            CmdExtendedErrorList cmdExtendedErrorList = (CmdExtendedErrorList)hashtable.get(ERROR_DATA);
            System.out.println("varyOnOffIo() failed, extended errors:\n" + cmdExtendedErrorList);
        } else if (n2 != 0) {
            System.out.println("varyOnOffIo() failed, error code " + n2);
        }
    }

    UnsignedInt16[] getLparIoPoolConfigurationCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = fSPCmdMgr.doPhypCommand(GET_LPAR_IO_POOL_CONFIGURATION, new String[]{unsignedInt16.toString()});
        UnsignedInt16 unsignedInt162 = (UnsignedInt16)hashtable.get(LPAR_ID);
        Object[] objectArray = (Object[])hashtable.get(IO_POOL_LIST);
        UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Hashtable hashtable2 = (Hashtable)objectArray[i];
            unsignedInt16Array[i] = (UnsignedInt16)hashtable2.get(IO_POOL_ID);
        }
        return unsignedInt16Array;
    }

    void setLparIoPoolConfigurationCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16[] unsignedInt16Array) throws PIHscServerException, PIHscCmdMgrException {
        String string = "";
        if (unsignedInt16Array != null && unsignedInt16Array.length > 0) {
            string = ByteUtilities.toHexString(unsignedInt16Array);
        }
        fSPCmdMgr.doPhypCommand(SET_LPAR_IO_POOL_CONFIGURATION, new String[]{unsignedInt16.toString(), "" + unsignedInt16Array.length, string});
    }

    void setSharedMemClusterIoCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt32 unsignedInt32, UnsignedInt16 unsignedInt163, UnsignedInt16 unsignedInt164, UnsignedInt16 unsignedInt165, UnsignedInt8 unsignedInt8) throws PIHscServerException {
        fSPCmdMgr.doPhypCommand(SET_SHARED_MEMORY_CLUSTER_IO, new String[]{unsignedInt16.toString(), unsignedInt162.toString(), unsignedInt32.toString(), unsignedInt163.toString(), unsignedInt164.toString(), unsignedInt165.toString(), unsignedInt8.toString()}, 0, null, unsignedInt32, null, unsignedInt163, unsignedInt162);
    }
}

